from django.shortcuts import render, redirect, get_object_or_404
from .models import Equipement
from datetime import date, timedelta, datetime
from django.template.loader import render_to_string
from django.http import HttpResponse
from weasyprint import HTML

def liste_equipements(request):
    equipements = Equipement.objects.all().order_by("date_prochaine_verification")
    
    today = date.today()
    seuil = today + timedelta(days=30)

    return render(request, "liste.html", {
        "equipements": equipements,
        "today": today,
        "seuil": seuil,
    })

def ajouter_equipement(request):
    if request.method == "POST":
        e = Equipement(
            dt=request.POST.get("dt"),
            site=request.POST.get("site"),
            lieu=request.POST.get("lieu"),
            description=request.POST.get("description"),
            marque=request.POST.get("marque"),
            capacite_tonne=request.POST.get("capacite_tonne") or None,
            type_appareil=request.POST.get("type_appareil"),
            criticite=bool(request.POST.get("criticite")),
            frequence_verification=request.POST.get("frequence_verification"),
            date_derniere_verification=parse_date(request.POST.get("date_derniere_verification")),
            date_prochaine_verification=parse_date(request.POST.get("date_prochaine_verification")),
        )
        e.save()
        return redirect("liste_equipements")
    return render(request, "form.html")

def editer_equipement(request, id):
    equipement = get_object_or_404(Equipement, pk=id)
    if request.method == "POST":
        equipement.dt = request.POST.get("dt")
        equipement.site = request.POST.get("site")
        equipement.lieu = request.POST.get("lieu")
        equipement.description = request.POST.get("description")
        equipement.marque = request.POST.get("marque")
        equipement.capacite_tonne = request.POST.get("capacite_tonne") or None
        equipement.type_appareil = request.POST.get("type_appareil")
        equipement.criticite = bool(request.POST.get("criticite"))
        equipement.frequence_verification = request.POST.get("frequence_verification")
        equipement.date_derniere_verification = parse_date(request.POST.get("date_derniere_verification"))
        equipement.date_prochaine_verification = parse_date(request.POST.get("date_prochaine_verification"))
        equipement.save()
        return redirect("liste_equipements")
    return render(request, "form.html", {"equipement": equipement})

def parse_date(val):
    try:
        return datetime.strptime(val, "%Y-%m-%d").date()
    except:
        return None
    
def rapport_pdf(request, id):
    equipement = get_object_or_404(Equipement, pk=id)
    html_string = render_to_string("rapport.html", {"equipement": equipement})
    pdf_file = HTML(string=html_string).write_pdf()

    response = HttpResponse(pdf_file, content_type="application/pdf")
    response['Content-Disposition'] = f'filename="rapport_{equipement.id}.pdf"'
    return response