from django.db import models

class Equipement(models.Model):
    dt = models.CharField(max_length=50)
    site = models.CharField(max_length=100)
    lieu = models.CharField(max_length=100)
    description = models.CharField(max_length=200)
    marque = models.CharField(max_length=100, blank=True, null=True)
    capacite_tonne = models.DecimalField(max_digits=5, decimal_places=2, null=True, blank=True)
    type_appareil = models.CharField(max_length=100)
    criticite = models.BooleanField(default=False)
    frequence_verification = models.CharField(max_length=50)
    date_derniere_verification = models.DateField(null=True, blank=True)
    date_prochaine_verification = models.DateField(null=True, blank=True)
    date_verification_reelle = models.DateField(null=True, blank=True)
    date_fin_verification = models.DateField(null=True, blank=True)
    date_remise_rapport = models.DateField(null=True, blank=True)
    reserves = models.TextField(blank=True, null=True)
    rapport = models.FileField(upload_to="rapports/", blank=True, null=True)
    date_levée_reserves = models.DateField(null=True, blank=True)

    def __str__(self):
        return f"{self.description} - {self.lieu}"

