import pandas as pd
from django.core.management.base import BaseCommand
from equipements.models import Equipement
from datetime import datetime

class Command(BaseCommand):
    help = "Importe les équipements depuis un fichier Excel"

    def add_arguments(self, parser):
        parser.add_argument('fichier', type=str, help="Chemin vers le fichier Excel")

    def handle(self, *args, **kwargs):
        fichier = kwargs['fichier']
        df = pd.read_excel(fichier, sheet_name='Eqpts de Levage 2025', skiprows=1)

        total = 0
        for _, row in df.iterrows():
            if pd.isna(row['Description']):
                continue

            eq = Equipement(
                dt=row['DT'],
                site=row['SITE'],
                lieu=row['Lieu'],
                description=row['Description'],
                marque=row['Marque'],
                capacite_tonne=row.get('Capacité ( Tonne )', None),
                type_appareil=row['Type'],
                criticite=str(row['Criticité']).strip().lower() == 'oui',
                frequence_verification=row['Frequence de vérification'],
                date_derniere_verification=convert_date(row.get('Date derniere verification')),
                date_prochaine_verification=convert_date(row.get('Date prochaine verification')),
                date_verification_reelle=convert_date(row.get('Date de la vérification')),
                date_fin_verification=convert_date(row.get('Date de fin de vérification')),
                date_remise_rapport=convert_date(row.get('Date de remise rapport')),
                reserves=row.get('Réserves'),
                date_levée_reserves=convert_date(row.get('Date de levée de réserves')),
            )
            eq.save()
            total += 1

        self.stdout.write(self.style.SUCCESS(f"{total} équipements importés avec succès."))

def convert_date(value):
    if pd.isna(value):
        return None
    if isinstance(value, datetime):
        return value.date()
    try:
        return pd.to_datetime(value).date()
    except Exception:
        return None
