
# Fulfillment Fulfillment Entry

Links an order line item to a fulfillment. Each entry must reference
a valid `uid` for an order line item in the `line_item_uid` field, as well as a `quantity` to
fulfill.

## Structure

`FulfillmentFulfillmentEntry`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `uid` | `?string` | Optional | A unique ID that identifies the fulfillment entry only within this order.<br>**Constraints**: *Maximum Length*: `60` | getUid(): ?string | setUid(?string uid): void |
| `lineItemUid` | `string` | Required | The `uid` from the order line item.<br>**Constraints**: *Minimum Length*: `1` | getLineItemUid(): string | setLineItemUid(string lineItemUid): void |
| `quantity` | `string` | Required | The quantity of the line item being fulfilled, formatted as a decimal number.<br>For example, `"3"`.<br><br>Fulfillments for line items with a `quantity_unit` can have non-integer quantities.<br>For example, `"1.70000"`.<br>**Constraints**: *Minimum Length*: `1`, *Maximum Length*: `12` | getQuantity(): string | setQuantity(string quantity): void |
| `metadata` | `?array<string,string>` | Optional | Application-defined data attached to this fulfillment entry. Metadata fields are intended<br>to store descriptive references or associations with an entity in another system or store brief<br>information about the object. Square does not process this field; it only stores and returns it<br>in relevant API calls. Do not use metadata to store any sensitive information (such as personally<br>identifiable information or card details).<br><br>Keys written by applications must be 60 characters or less and must be in the character set<br>`[a-zA-Z0-9_-]`. Entries can also include metadata generated by Square. These keys are prefixed<br>with a namespace, separated from the key with a ':' character.<br><br>Values have a maximum length of 255 characters.<br><br>An application can have up to 10 entries per metadata field.<br><br>Entries written by applications are private and can only be read or modified by the same<br>application.<br><br>For more information, see [Metadata](https://developer.squareup.com/docs/build-basics/metadata). | getMetadata(): ?array | setMetadata(?array metadata): void |

## Example (as JSON)

```json
{
  "uid": null,
  "line_item_uid": "line_item_uid0",
  "quantity": "quantity6",
  "metadata": null
}
```

